 <?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<div class="d-flex align-items-center justify-content-between">
								<h3 class="card-title">
									<?php echo e(__('attendance.sheet_title')); ?>

								</h3>
								<div class="key d-flex align-items-center">
									<div class="d-inline">
										<i class="fas fa-lg fa-square bg-present"></i>
										<?php echo e(__('attendance.present')); ?>

									</div>
									<div class="d-inline">
										<i class="fas fa-lg fa-square bg-absent ml-3"></i>
										<?php echo e(__('attendance.absent')); ?>

									</div>

								</div>
							</div>
						</div>

						<form method="post" action="<?php echo e(route('attendance.store')); ?>" enctype="multipart/form-data">
							<?php echo e(csrf_field()); ?>

							<div class="card-body">
								<div class="row">
									<div class="col-12">
										<div
											class="d-flex justify-content-between align-items-center bg-light p-3 rounded-lg">
											<div class="prev ml-1">
												<a href="<?php echo e(route('attendance.index', ['type' => 'prev'])); ?>"
													class="btn btn-primary px-3">
													<i class="fas fa-angle-left fa-lg"></i></a>
												<a href="<?php echo e(route('attendance.index')); ?>" class="btn btn-success px-3">
													<i class="fas fa-redo-alt"></i>
												</a>
											</div>
											<div class="">
												<p class="mb-0 text-lg">
													<?php echo e(__('attendance.attendance_title', ['from' => $dates['date1'],
													'to' => $dates['date2']])); ?>

												</p>
											</div>
											<div class="next mr-1">
												<button type="submit" class="btn btn-success px-3">
													<i class="fas fa-save"></i>
												</button>
												<a href="<?php echo e(route('attendance.index', ['type' => 'next'])); ?>"
													class="btn btn-primary px-3">
													<i class="fas fa-angle-right fa-lg"></i>
												</a>
											</div>
										</div>
									</div>
								</div>
								<div class="row mt-3">
									<div class="col-12">
										<div class="table-responsive">
											<table class="table attendance-table table-striped   mb-0">
												<thead>
													<tr>
														<th class="text-uppercase nowrap px-2" rowspan="2"><?php echo e(__('attendance.th_member_name')); ?></th>
														<th class="text-uppercase nowrap px-2" rowspan="2"><?php echo e(__('attendance.th_reg_no')); ?></th>
														<th class="text-uppercase nowrap" colspan="<?php echo e($days); ?>">
															<?php echo e(__('attendance.th_date')); ?>

														</th>
														<th class="text-uppercase nowrap px-3" colspan="2">
															<?php echo e(__('attendance.th_total')); ?>

														</th>
													</tr>
													<tr>
														<?php for($i = 1; $i <= $days; $i++): ?> <th class="att-select">
															<?php echo e($i); ?>

															</th>
															<?php endfor; ?>
															<th class="bg-present att-key">
																<span class="text-white">P</span>
															</th>
															<th class="bg-absent att-key">
																<span class="text-white">A</span>
															</th>
													</tr>
												</thead>
												<tbody>
													<?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td class="nowrap text-left px-2">
															<input type="hidden" value="<?php echo e($member->id); ?>"
																name="members[<?php echo e($index); ?>][id]" />
															<div class="d-flex align-items-center">
																<div class="rounded border attendance-image mr-2"
																	style="background-image: url('<?php echo e(img_url($member->profile_picture)); ?>');">
																</div>
																<?php echo e($member->name); ?>

															</div>
														</td>
														<td class="nowrap px-2">
															<?php echo e($member->reg_no); ?>

														</td>

														<?php for($i = 1; $i <= $days; $i++): ?> <?php
															$status=checkStatus($member->attendances, $i);
															?>

															<td class="att-select">
																<input type="hidden" class="day" value="<?php echo e($status); ?>"
																	name="members[<?php echo e($index); ?>][days][<?php echo e($i); ?>]" />
																<div class="btn-group w-100">
																	<button type="button"
																		class="btn attendance-select <?php echo e(($status == 'present') ? 'present-button' : ($status ==   'absent' ? 'absent-button' : '')); ?> dropdown-toggle rounded-0"
																		data-toggle="dropdown"></button>
																	<ul class="dropdown-menu py-0">
																		<li>
																			<a class="dropdown-item attendance-status"
																				data-status="present" href="#">
																				<div class="d-inline">
																					<i
																						class="fas fa-square bg-present elevation-1"></i>
																					<?php echo e(__('attendance.present')); ?>

																				</div>
																			</a>
																		</li>
																		<li>
																			<a class="dropdown-item attendance-status"
																				data-status="absent" href="#">
																				<div class="d-inline">
																					<i
																						class="fas fa-square bg-absent elevation-1"></i>
																					<?php echo e(__('attendance.absent')); ?>

																				</div>
																			</a>
																		</li>
																	</ul>
																</div>
															</td>
															<?php endfor; ?>

															<th class="text-center att-key">
																<?php echo e(presentCount($member->attendances)); ?>

															</th>
															<th class="text-center att-key">
																<?php echo e(absentCount($member->attendances)); ?>

															</th>
													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													<?php if(count($members) == 0): ?>
													<tr>
														<td colspan="<?php echo e($days + 4); ?>">
															<p class="text-center text-muted mb-0">
																<?php echo e(__('attendance.no_record_found')); ?>

															</p>
														</td>
													</tr>
													<?php endif; ?>
												</tbody>
											</table>
										</div>
									</div>
									<div class="col-12">
										<div class="d-flex justify-content-end mt-3">
											<?php if($paginate): ?>
											<?php echo e($members->links()); ?>

											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-script'); ?>
<script>
	$(function () {
		"use strict";

		$(".attendance-status").on("click", function (event) {
			event.preventDefault();
			var status = $(this).data("status");

			switch (status) {
				case "present":
					$(this).closest(".att-select").find(".day").val("present");
					$(this).closest(".btn-group").find(".btn").removeClass("absent-button");
					$(this).closest(".btn-group").find(".btn").removeClass("bg-transparent");
					$(this).closest(".btn-group").find(".btn").addClass("present-button");
					break;
				case "absent":
					$(this).closest(".att-select").find(".day").val("absent");
					$(this).closest(".btn-group").find(".btn").removeClass("present-button");
					$(this).closest(".btn-group").find(".btn").removeClass("bg-transparent");
					$(this).closest(".btn-group").find(".btn").addClass("absent-button");
					break;
			}
		});
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/attendance/index.blade.php ENDPATH**/ ?>